/*
 * SIP .NET samples
 * Copyright (c) 2006 - Independensoft.
 * 
 * This file is part of Independentsoft SIP .NET. The source code in this file 
 * is only intended as a supplement to the documentation, and is provided 
 * "as is", without warranty of any kind, either expressed or implied.
 */

using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using Independentsoft.Sip;

namespace PocketPCRegister
{
	public class Form1 : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.TextBox fromTextBox;
		internal System.Windows.Forms.TextBox passwordTextBox;
		internal System.Windows.Forms.TextBox usernameTextBox;
		internal System.Windows.Forms.TextBox logTextBox;
		internal System.Windows.Forms.Button registerButton;
		internal System.Windows.Forms.TextBox portTextBox;
		internal System.Windows.Forms.TextBox domainTextBox;
		private static Logger logger;
		private System.Windows.Forms.Button disconnectButton;
		private static SipClient client;

		public Form1()
		{
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.fromTextBox = new System.Windows.Forms.TextBox();
			this.passwordTextBox = new System.Windows.Forms.TextBox();
			this.usernameTextBox = new System.Windows.Forms.TextBox();
			this.logTextBox = new System.Windows.Forms.TextBox();
			this.registerButton = new System.Windows.Forms.Button();
			this.portTextBox = new System.Windows.Forms.TextBox();
			this.domainTextBox = new System.Windows.Forms.TextBox();
			this.disconnectButton = new System.Windows.Forms.Button();
			// 
			// fromTextBox
			// 
			this.fromTextBox.Location = new System.Drawing.Point(8, 32);
			this.fromTextBox.Size = new System.Drawing.Size(212, 22);
			this.fromTextBox.Text = "Bob@mydomain.com";
			// 
			// passwordTextBox
			// 
			this.passwordTextBox.Location = new System.Drawing.Point(120, 56);
			this.passwordTextBox.Text = "password";
			// 
			// usernameTextBox
			// 
			this.usernameTextBox.Location = new System.Drawing.Point(8, 56);
			this.usernameTextBox.Text = "username";
			// 
			// logTextBox
			// 
			this.logTextBox.Location = new System.Drawing.Point(8, 120);
			this.logTextBox.Multiline = true;
			this.logTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.logTextBox.Size = new System.Drawing.Size(224, 144);
			this.logTextBox.Text = "";
			// 
			// registerButton
			// 
			this.registerButton.Location = new System.Drawing.Point(8, 88);
			this.registerButton.Size = new System.Drawing.Size(100, 22);
			this.registerButton.Text = "Register";
			this.registerButton.Click += new System.EventHandler(this.registerButton_Click);
			// 
			// portTextBox
			// 
			this.portTextBox.Location = new System.Drawing.Point(120, 8);
			this.portTextBox.Text = "5060";
			// 
			// domainTextBox
			// 
			this.domainTextBox.Location = new System.Drawing.Point(8, 8);
			this.domainTextBox.Text = "mydomain.com";
			// 
			// disconnectButton
			// 
			this.disconnectButton.Location = new System.Drawing.Point(120, 88);
			this.disconnectButton.Size = new System.Drawing.Size(100, 22);
			this.disconnectButton.Text = "Disconnect";
			this.disconnectButton.Click += new System.EventHandler(this.disconnectButton_Click);
			// 
			// Form1
			// 
			this.Controls.Add(this.disconnectButton);
			this.Controls.Add(this.passwordTextBox);
			this.Controls.Add(this.usernameTextBox);
			this.Controls.Add(this.logTextBox);
			this.Controls.Add(this.registerButton);
			this.Controls.Add(this.portTextBox);
			this.Controls.Add(this.domainTextBox);
			this.Controls.Add(this.fromTextBox);
			this.Text = "Pocket PC Register";

		}
		#endregion

		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void registerButton_Click(object sender, System.EventArgs e)
		{
			client = new SipClient(domainTextBox.Text, Int32.Parse(portTextBox.Text), usernameTextBox.Text, passwordTextBox.Text);

			logger = new Logger();
			logger.WriteLog += new WriteLogEventHandler(OnWriteLog);
			client.Logger = logger;

			client.ReceiveRequest += new ReceiveRequestEventHandler(OnReceiveRequest);
			client.ReceiveResponse += new ReceiveResponseEventHandler(OnReceiveResponse);

			client.Connect();

			client.Register("sip:" + domainTextBox.Text, fromTextBox.Text, "sip:" + client.LocalIPEndPoint.ToString());
		}

		private void disconnectButton_Click(object sender, System.EventArgs e)
		{
			client.Disconnect();
		}

		private void OnReceiveRequest(object sender, RequestEventArgs e) 
		{ 
			//accept any request from server or another sip user agent
			client.AcceptRequest(e.Request);
		}

		private void OnReceiveResponse(object sender,ResponseEventArgs e) 
		{ 
		}

		private void OnWriteLog(object sender, WriteLogEventArgs e) 
		{ 
			logTextBox.Text += e.Log;
		}
	}
}
