''
'' SIP .NET samples
'' Copyright (c) 2006 - Independensoft.
''
'' This file is part of Independentsoft SIP .NET. The source code in this file 
'' is only intended as a supplement to the documentation, and is provided 
'' "as is", without warranty of any kind, either expressed or implied.
''

Imports System
Imports Independentsoft.Sip

Public Class Form1
    Inherits System.Windows.Forms.Form
    Friend WithEvents domainTextBox As System.Windows.Forms.TextBox
    Friend WithEvents portTextBox As System.Windows.Forms.TextBox
    Friend WithEvents registerButton As System.Windows.Forms.Button
    Friend WithEvents logTextBox As System.Windows.Forms.TextBox
    Friend WithEvents usernameTextBox As System.Windows.Forms.TextBox
    Friend WithEvents passwordTextBox As System.Windows.Forms.TextBox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Private logger As logger
    Private client As SipClient

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()
        InitializeComponent()
    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        MyBase.Dispose(disposing)
    End Sub

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents fromTextBox As System.Windows.Forms.TextBox
    Friend WithEvents disconnectButton As System.Windows.Forms.Button
    Private Sub InitializeComponent()
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.domainTextBox = New System.Windows.Forms.TextBox
        Me.portTextBox = New System.Windows.Forms.TextBox
        Me.registerButton = New System.Windows.Forms.Button
        Me.logTextBox = New System.Windows.Forms.TextBox
        Me.usernameTextBox = New System.Windows.Forms.TextBox
        Me.passwordTextBox = New System.Windows.Forms.TextBox
        Me.fromTextBox = New System.Windows.Forms.TextBox
        Me.disconnectButton = New System.Windows.Forms.Button
        '
        'domainTextBox
        '
        Me.domainTextBox.Location = New System.Drawing.Point(8, 8)
        Me.domainTextBox.Text = "mydomain.com"
        '
        'portTextBox
        '
        Me.portTextBox.Location = New System.Drawing.Point(120, 8)
        Me.portTextBox.Text = "5060"
        '
        'registerButton
        '
        Me.registerButton.Location = New System.Drawing.Point(8, 80)
        Me.registerButton.Size = New System.Drawing.Size(100, 22)
        Me.registerButton.Text = "Register"
        '
        'logTextBox
        '
        Me.logTextBox.Location = New System.Drawing.Point(8, 112)
        Me.logTextBox.Multiline = True
        Me.logTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.logTextBox.Size = New System.Drawing.Size(224, 152)
        Me.logTextBox.Text = ""
        '
        'usernameTextBox
        '
        Me.usernameTextBox.Location = New System.Drawing.Point(8, 56)
        Me.usernameTextBox.Text = "username"
        '
        'passwordTextBox
        '
        Me.passwordTextBox.Location = New System.Drawing.Point(120, 56)
        Me.passwordTextBox.Text = "password"
        '
        'fromTextBox
        '
        Me.fromTextBox.Location = New System.Drawing.Point(8, 32)
        Me.fromTextBox.Size = New System.Drawing.Size(212, 22)
        Me.fromTextBox.Text = "Bob@mydomain.com"
        '
        'disconnectButton
        '
        Me.disconnectButton.Font = New System.Drawing.Font("Tahoma", 9.0!, System.Drawing.FontStyle.Regular)
        Me.disconnectButton.Location = New System.Drawing.Point(120, 80)
        Me.disconnectButton.Size = New System.Drawing.Size(100, 22)
        Me.disconnectButton.Text = "Disconnect"
        '
        'Form1
        '
        Me.Controls.Add(Me.disconnectButton)
        Me.Controls.Add(Me.fromTextBox)
        Me.Controls.Add(Me.passwordTextBox)
        Me.Controls.Add(Me.usernameTextBox)
        Me.Controls.Add(Me.logTextBox)
        Me.Controls.Add(Me.registerButton)
        Me.Controls.Add(Me.portTextBox)
        Me.Controls.Add(Me.domainTextBox)
        Me.Menu = Me.MainMenu1
        Me.Text = "Pocket PC Register"

    End Sub

#End Region

    Private Sub registerButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles registerButton.Click
        client = New SipClient(domainTextBox.Text, Int32.Parse(portTextBox.Text), usernameTextBox.Text, passwordTextBox.Text)

        logger = New Logger
        AddHandler logger.WriteLog, AddressOf OnWriteLog
        client.Logger = logger

        AddHandler client.ReceiveRequest, AddressOf OnReceiveRequest
        AddHandler client.ReceiveResponse, AddressOf OnReceiveResponse

        client.Connect()

        client.Register("sip:" + domainTextBox.Text, fromTextBox.Text, "sip:" + client.LocalIPEndPoint.ToString())
    End Sub

    Private Sub OnReceiveRequest(ByVal sender As Object, ByVal e As RequestEventArgs)
        'accept any request from server or another sip user agent
        client.AcceptRequest(e.Request)
    End Sub

    Private Sub OnReceiveResponse(ByVal sender As Object, ByVal e As ResponseEventArgs)
    End Sub

    Private Sub OnWriteLog(ByVal sender As Object, ByVal e As WriteLogEventArgs)
        logTextBox.Text += e.Log
    End Sub

    Private Sub disconnectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles disconnectButton.Click
        client.Disconnect()
    End Sub
End Class
